<?php
if (!class_exists('VBSECURITY'))
{
	// Fetch required classes
	require_once(DIR . '/dbtech/vbsecurity/includes/class_core.php');
	require_once(DIR . '/dbtech/vbsecurity/includes/class_cache.php');
	if (intval($vbulletin->versionnumber) == 3 AND !class_exists('vB_Template'))
	{
		// We need the template class
		require_once(DIR . '/dbtech/vbsecurity/includes/class_template.php');
	}

	if (isset($this) AND is_object($this))
	{
		// Loads the cache class
		VBSECURITY_CACHE::init($vbulletin, $this->datastore_entries, array('dbtech_vbsecurity_actions', 'dbtech_vbsecurity_watchers'));
	}
	else
	{
		// Loads the cache class
		VBSECURITY_CACHE::init($vbulletin, $specialtemplates, array('dbtech_vbsecurity_actions', 'dbtech_vbsecurity_watchers'));
	}

	// Initialise forumon
	VBSECURITY::init($vbulletin);

	if ($vbulletin->options['dbtech_vbsecurity_active'] AND VBSECURITY::$permissions['canview'])
	{
		$show['vbsecurity'] = $vbulletin->options['dbtech_vbsecurity_navbar'];
		$show['vbsecurity_ispro'] = VBSECURITY::$isPro;
		if ($vbulletin->options['dbtech_vbsecurity_integration'] & 1)
		{
			$show['vbsecurity_ql'] = true;
		}
		if ($vbulletin->options['dbtech_vbsecurity_integration'] & 2)
		{
			$show['vbsecurity_com'] = true;
		}
	}

	// Show branding or not
	$show['vbsecurity_branding'] = $vbulletin->options['dbtech_vbsecurity_branding_free'] != base64_decode('dmJ3YXJlei5uZXQ=');
	$show['dbtech_vbsecurity_producttype'] = (VBSECURITY::$isPro ? ' (Pro)' : ' (Lite)');

	if ($show['vbsecurity_branding'] AND !$show['_dbtech_branding_override'])
	{
		$brandingVariables = array(
			'flavour' 			=> 'vBulletin Security provided by ',
			'productid' 		=> 123,
			'utm_source' 		=> str_replace('www.', '', htmlspecialchars_uni($_SERVER['HTTP_HOST'])),
			'utm_content' 		=> (VBSECURITY::$isPro ? 'Pro' : 'Lite'),
			'referrerid' 		=> $vbulletin->options['dbtech_vbsecurity_referral'],
			'title' 			=> 'vBSecurity',
			'displayversion' 	=> $vbulletin->options['dbtech_vbsecurity_displayversion'],
			'version' 			=> '1.1.8 Patch Level 2',
			'producttype' 		=> $show['dbtech_vbsecurity_producttype']
		);

		$str = $brandingVariables['flavour'] . '
			<a rel="nofollow" href="http://www.dragonbyte-tech.com/vbecommerce.php' . ($brandingVariables['productid'] ? '?productid=' . $brandingVariables['productid'] . '&do=product&' : '?') . 'utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=product&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">' . $brandingVariables['title'] . ($brandingVariables['displayversion'] ? ' v' . $brandingVariables['version'] : '') . $brandingVariables['producttype'] . '</a> -
			<a rel="nofollow" href="http://www.dragonbyte-tech.com/?utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=site&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">vBulletin Mods &amp; Addons</a> Copyright &copy; ' . date('Y') . ' DragonByte Technologies Ltd.';
		$vbulletin->options['copyrighttext'] = (trim($vbulletin->options['copyrighttext']) != '' ? $str . '<br />' . $vbulletin->options['copyrighttext'] : $str);
	}

	// Set the superadmins
	VBSECURITY::$cache['superadmins'] = preg_split('#\s*,\s*#s', $vbulletin->config['SpecialUsers']['superadministrators'], -1, PREG_SPLIT_NO_EMPTY);

	if ($vbulletin->options['dbtech_vbsecurity_active'])
	{
		switch (VB_AREA)
		{
			case 'AdminCP':
			case 'ModCP':
				require_once(DIR . '/includes/adminfunctions.php');

				if (
					$vbulletin->userinfo['adminpassword']
					AND (
						trim($_SERVER['PHP_AUTH_USER']) != $vbulletin->userinfo['username']
						OR md5(md5(trim($_SERVER['PHP_AUTH_PW'])) . $vbulletin->userinfo['salt']) != $vbulletin->userinfo['adminpassword']
					)
				)
				{
					header('WWW-Authenticate: Basic realm="' . $vbulletin->options['bbtitle'] . ' ' . $vbphrase['admin_control_panel'] . '"');
					header("HTTP/1.0 401 Unauthorized");
					print_cp_no_permission();
				}

				if ($vbulletin->options['dbtech_vbsecurity_allowip'] = trim($vbulletin->options['dbtech_vbsecurity_allowip']) AND
					(!in_array($vbulletin->userinfo['userid'], VBSECURITY::$cache['superadmins']) OR !$vbulletin->options['dbtech_vbsecurity_allowip_exclude'])
				)
				{
					$user_ipaddress = IPADDRESS . '.';
					$user_alt_ipaddress = ALT_IP . '.';

					$allow = false;
					$addresses = preg_split('#\s+#', $vbulletin->options['dbtech_vbsecurity_allowip'], -1, PREG_SPLIT_NO_EMPTY);
					foreach ($addresses AS $allowed_ip)
					{
						if (strpos($allowed_ip, '*') === false AND $allowed_ip{strlen($allowed_ip) - 1} != '.')
						{
							$allowed_ip .= '.';
						}

						$allowed_ip_regex = str_replace('\*', '(.*)', preg_quote($allowed_ip, '#'));

						// Check both IP addresses, it doesnt really matter if they are the same.
						if (preg_match('#^' . $allowed_ip_regex . '#U', $user_ipaddress) OR preg_match('#^' . $allowed_ip_regex . '#U', $user_alt_ipaddress))
						{
							$allow = true;
						}
					}

					if (!$allow)
					{
						print_stop_message('dbtech_vbsecurity_ipwhitelist', IPADDRESS, ALT_IP);
					}
				}

				/*DBTECH_PRO_START*/
				$getperms = $db->query_first_slave("
					SELECT *
					FROM " . TABLE_PREFIX . "administrator
					WHERE userid = " . $vbulletin->userinfo['userid']
				);

				if ($getperms AND !($getperms['dbtech_vbsecurityadminperms'] & $vbulletin->bf_misc_dbtech_vbsecurityadminperms['ipcheckexempt']) AND $vbulletin->userinfo['userid'])
				{
					$db->error = '';
					$db->hide_errors();
					$record = VBSECURITY::$db->fetchRow('
						SELECT * FROM $dbtech_vbsecurity_adminauth
						WHERE userid = ?
							AND ipaddress = ?
					', array(
						$vbulletin->userinfo['userid'],
						IPADDRESS
					));
					$db->show_errors();

					if (!$db->error)
					{
						if (!$record)
						{
							// Create the hash
							$hash = md5(mt_rand(0, 1000000));

							// We had no record of this IP address
							$info = array(
								'username' 		=> $vbulletin->userinfo['username'],
								'bbtitle' 		=> $vbulletin->options['bbtitle'],
								'bburl' 		=> $vbulletin->options['bburl'],
								'admincpdir' 	=> $vbulletin->config['Misc']['admincpdir'],
								'ipaddress' 	=> IPADDRESS,
								'hash' 			=> $hash
							);

							$db->error = '';
							$db->hide_errors();

							// Insert the record
							VBSECURITY::$db->insert('dbtech_vbsecurity_adminauth', array(
								'userid' 	=> $vbulletin->userinfo['userid'],
								'ipaddress' => $info['ipaddress'],
								'dateline' 	=> TIMENOW,
								'authhash' 	=> $info['hash'],
								'verified' 	=> '0'
							));

							$db->show_errors();

							if (!$db->error)
							{
								eval(fetch_email_phrases('dbtech_vbsecurity_access_new_ip_message', -1, 'dbtech_vbsecurity_access_new_ip_title'));

								if ($vbulletin->userinfo['email'])
								{
									// FIRE ZE EMAILZ
									vbmail($vbulletin->userinfo['email'], $subject, $message, true);
								}
							}

							// This IP address is currently awaiting authorisation
							print_stop_message('dbtech_vbsecurity_awaiting_authorisation', IPADDRESS, $vbulletin->userinfo['username']);
						}
						else if (!$record['verified'])
						{
							if (THIS_SCRIPT == 'vbsecurity' AND $_REQUEST['do'] == 'authorise')
							{
								if ($_REQUEST['authhash'] == $record['authhash'])
								{
									// Success!
									VBSECURITY::$db->update('dbtech_vbsecurity_adminauth', array(
										'verified' 	=> '1'
									), 'WHERE userid = ' . intval($record['userid']) . ' AND ipaddress = ' . $db->sql_prepare($record['ipaddress']));

									define('CP_REDIRECT', 'index.php');
									print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['ip_address'], $vbphrase['dbtech_vbsecurity_added']);
								}
								else
								{
									// This IP address is currently awaiting authorisation
									print_stop_message('dbtech_vbsecurity_incorrect_authorisation', IPADDRESS, $vbulletin->userinfo['username']);
								}
							}
							else
							{
								// This IP address is currently awaiting authorisation
								print_stop_message('dbtech_vbsecurity_awaiting_authorisation', IPADDRESS, $vbulletin->userinfo['username']);
							}
						}
					}
				}
				/*DBTECH_PRO_END*/
				break;

			case 'Forum':
				if ($vbulletin->userinfo['dbtech_vbsecurity_forcenewpass']
					AND (THIS_SCRIPT != 'login' AND THIS_SCRIPT != 'profile' AND THIS_SCRIPT != 'ajax')
					OR (THIS_SCRIPT == 'profile' AND $_REQUEST['do'] != 'editpassword' AND $_POST['do'] != 'updatepassword')
					OR (THIS_SCRIPT == 'ajax' AND $_REQUEST['do'] != 'imagereg' AND $_REQUEST['do'] != 'securitytoken' AND $_REQUEST['do'] != 'dismissnotice')
				)
				{
					$show['_passwordexpired'] = true;
				}
		}
	}
}
?>